package com.ejie.ab04b.dao;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;
import javax.sql.DataSource;

import org.springframework.dao.support.DataAccessUtils;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

import com.ejie.ab04b.constantes.Secuencias;
import com.ejie.ab04b.model.DatosEnvioPostal;
import com.ejie.x38.dao.RowNumResultSetExtractor;
import com.ejie.x38.dto.JQGridManager;
import com.ejie.x38.dto.JQGridRequestDto;
import com.ejie.x38.dto.TableRowDto;

/**
 * Ab0469s00DaoImpl generated by UDA, 24-Feb-2017 11:21:23.
 * 
 * @author UDA
 */

@Repository()
@Transactional()
public class DatosEnvioPostalDaoImpl implements DatosEnvioPostalDao {

	private static final String QUERY_SELECT = "SELECT t1.ID_DATOS_ENVIO_POSTAL_069 IDDATOSENVIOPOSTAL069, t1.ID_ENVIO_069 IDENVIO069, t1.COD_ENVIO_069 CODENVIO069, t1.ID_REMESA_069 IDREMESA069, t1.COD_REMESA_069 CODREMESA069, t1.ID_COLECCION_069 IDCOLECCION069, t1.COD_COLECCION_069 CODCOLECCION069, t1.COD_SITUACION_ENVIO_069 CODSITUACIONENVIO069, t1.DESC_SITUACION_ENVIO_ES_069 DESCSITUACIONENVIOES069, t1.DESC_SITUACION_ENVIO_EU_069 DESCSITUACIONENVIOEU069, t1.ESTADO_ENVIO_069 ESTADOENVIO069, t1.FECNOTIFICACION_069 FECNOTIFICACION069, t1.FEC_SITUACION_ENVIO_069 FECSITUACIONENVIO069, t1.FECACUSE_069 FECACUSE069, t1.ESTADO_ACUSE_069 ESTADOACUSE069 FROM AB0469S00 t1 ";

	private JdbcTemplate jdbcTemplate;

	/*
	 * ROW_MAPPERS
	 */
	private RowMapper<DatosEnvioPostal> rwMap = new RowMapper<DatosEnvioPostal>() {
		public DatosEnvioPostal mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosEnvioPostal(
					resultSet.getLong("IDDATOSENVIOPOSTAL069"),
					resultSet.getInt("IDENVIO069"),
					resultSet.getString("CODENVIO069"),
					resultSet.getInt("IDREMESA069"),
					resultSet.getString("CODREMESA069"),
					resultSet.getInt("IDCOLECCION069"),
					resultSet.getString("CODCOLECCION069"),
					resultSet.getString("CODSITUACIONENVIO069"),
					resultSet.getString("DESCSITUACIONENVIOES069"),
					resultSet.getString("DESCSITUACIONENVIOEU069"),
					resultSet.getString("ESTADOENVIO069"),
					resultSet.getDate("FECNOTIFICACION069"),
					resultSet.getDate("FECSITUACIONENVIO069"),
					resultSet.getDate("FECACUSE069"),
					resultSet.getString("ESTADOACUSE069"));
		}
	};

	private RowMapper<DatosEnvioPostal> rwMapPK = new RowMapper<DatosEnvioPostal>() {
		public DatosEnvioPostal mapRow(ResultSet resultSet, int rowNum)
				throws SQLException {
			return new DatosEnvioPostal(
					resultSet.getLong("IDDATOSENVIOPOSTAL069"));
		}
	};

	/**
	 * Method use to set the datasource.
	 * 
	 * dataSource DataSource
	 *
	 * @param dataSource
	 *            the new data source
	 */
	@Resource()
	public void setDataSource(DataSource dataSource) {
		this.jdbcTemplate = new JdbcTemplate(dataSource);
	}

	/*
	 * OPERACIONES CRUD
	 */

	/**
	 * Inserts a single row in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 Ab0469s00
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal add(DatosEnvioPostal ab0469s00) {
		String query = "INSERT INTO AB0469S00 (ID_DATOS_ENVIO_POSTAL_069, ID_ENVIO_069, COD_ENVIO_069, ID_REMESA_069, COD_REMESA_069, ID_COLECCION_069, COD_COLECCION_069, COD_SITUACION_ENVIO_069, DESC_SITUACION_ENVIO_ES_069, DESC_SITUACION_ENVIO_EU_069, ESTADO_ENVIO_069, FECNOTIFICACION_069, FEC_SITUACION_ENVIO_069, FECACUSE_069,ESTADO_ACUSE_069) VALUES (?,?,?,?,?,?,?,?,?,?,?,?,?,?,?)";

		ab0469s00.setIdDatosEnvioPostal069(
				Secuencias.DATOS_ENVIO_POSTAL.getNextLong(jdbcTemplate));

		this.jdbcTemplate.update(query, ab0469s00.getIdDatosEnvioPostal069(),
				ab0469s00.getIdEnvio069(), ab0469s00.getCodEnvio069(),
				ab0469s00.getIdRemesa069(), ab0469s00.getCodRemesa069(),
				ab0469s00.getIdColeccion069(), ab0469s00.getCodColeccion069(),
				ab0469s00.getCodSituacionEnvio069(),
				ab0469s00.getDescSituacionEnvioEs069(),
				ab0469s00.getDescSituacionEnvioEu069(),
				ab0469s00.getEstadoEnvio069(),
				ab0469s00.getFecnotificacion069(),
				ab0469s00.getFecSituacionEnvio069(), ab0469s00.getFecAcuse069(),
				ab0469s00.getEstadoAcuse069());
		return ab0469s00;
	}

	/**
	 * Updates a single row in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 Ab0469s00
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal update(DatosEnvioPostal ab0469s00) {
		String query = "UPDATE AB0469S00 SET ID_ENVIO_069=?, COD_ENVIO_069=?, ID_REMESA_069=?, COD_REMESA_069=?, ID_COLECCION_069=?, COD_COLECCION_069=?, COD_SITUACION_ENVIO_069=?, DESC_SITUACION_ENVIO_ES_069=?, DESC_SITUACION_ENVIO_EU_069=?, ESTADO_ENVIO_069=?, FECNOTIFICACION_069=?, FEC_SITUACION_ENVIO_069=?, FECACUSE_069=?,ESTADO_ACUSE_069=? WHERE ID_DATOS_ENVIO_POSTAL_069=?";
		this.jdbcTemplate.update(query, ab0469s00.getIdEnvio069(),
				ab0469s00.getCodEnvio069(), ab0469s00.getIdRemesa069(),
				ab0469s00.getCodRemesa069(), ab0469s00.getIdColeccion069(),
				ab0469s00.getCodColeccion069(),
				ab0469s00.getCodSituacionEnvio069(),
				ab0469s00.getDescSituacionEnvioEs069(),
				ab0469s00.getDescSituacionEnvioEu069(),
				ab0469s00.getEstadoEnvio069(),
				ab0469s00.getFecnotificacion069(),
				ab0469s00.getFecSituacionEnvio069(), ab0469s00.getFecAcuse069(),
				ab0469s00.getEstadoAcuse069(),
				ab0469s00.getIdDatosEnvioPostal069());
		return ab0469s00;
	}

	/**
	 * Updates a single row in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 Ab0469s00
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the datos envio postal
	 */
	public DatosEnvioPostal updateSituacionEnvio(DatosEnvioPostal ab0469s00) {

		StringBuilder query = new StringBuilder(
				"UPDATE AB0469S00 SET COD_SITUACION_ENVIO_069 = ?, DESC_SITUACION_ENVIO_ES_069 = ?, DESC_SITUACION_ENVIO_EU_069 = ?, FEC_SITUACION_ENVIO_069=? WHERE ID_ENVIO_069 = ? ");

		this.jdbcTemplate.update(query.toString(),
				ab0469s00.getCodSituacionEnvio069(),
				ab0469s00.getDescSituacionEnvioEs069(),
				ab0469s00.getDescSituacionEnvioEu069(),
				ab0469s00.getFecSituacionEnvio069(), ab0469s00.getIdEnvio069());
		return ab0469s00;
	}

	/**
	 * Finds a single row in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 Ab0469s00
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the datos envio postal
	 */
	@Transactional(readOnly = true)
	public DatosEnvioPostal find(DatosEnvioPostal ab0469s00) {
		StringBuilder query = new StringBuilder(
				DatosEnvioPostalDaoImpl.QUERY_SELECT);
		query.append(" WHERE t1.ID_DATOS_ENVIO_POSTAL_069 = ? ");

		List<DatosEnvioPostal> ab0469s00List = this.jdbcTemplate.query(
				query.toString(), this.rwMap,
				ab0469s00.getIdDatosEnvioPostal069());
		return (DatosEnvioPostal) DataAccessUtils.uniqueResult(ab0469s00List);
	}

	/**
	 * Removes a single row in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 */
	public void remove(DatosEnvioPostal ab0469s00) {
		String query = "DELETE FROM AB0469S00 WHERE ID_DATOS_ENVIO_POSTAL_069=?";
		this.jdbcTemplate.update(query, ab0469s00.getIdDatosEnvioPostal069());
	}

	/**
	 * Finds a list of rows in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 jqGridRequestDto JQGridRequestDto List<Ab0469s00>
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosEnvioPostal> findAll(DatosEnvioPostal ab0469s00,
			JQGridRequestDto jqGridRequestDto) {
		StringBuilder query = new StringBuilder(
				DatosEnvioPostalDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0469s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosEnvioPostal>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/**
	 * Finds rows in the Ab0469s00 table using like.
	 * 
	 * ab0469s00 Ab0469s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<Ab0469s00>
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Transactional(readOnly = true)
	public List<DatosEnvioPostal> findAllLike(DatosEnvioPostal ab0469s00,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosEnvioPostalDaoImpl.QUERY_SELECT);

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0469s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		if (jqGridRequestDto != null) {
			query = JQGridManager.getPaginationQuery(jqGridRequestDto, query);
		}

		return (List<DatosEnvioPostal>) this.jdbcTemplate
				.query(query.toString(), this.rwMap, params.toArray());
	}

	/*
	 * OPERACIONES RUP_TABLE
	 */

	/**
	 * Counts rows in the Ab0469s00 table.
	 * 
	 * ab0469s00 Ab0469s00 Long
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllCount(DatosEnvioPostal ab0469s00) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0469S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereMap(ab0469s00);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Counts rows in the Ab0469s00 table using like.
	 * 
	 * ab0469s00 Ab0469s00 startsWith Boolean Long
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the long
	 */
	@Transactional(readOnly = true)
	public Long findAllLikeCount(DatosEnvioPostal ab0469s00,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				"SELECT COUNT(1) FROM AB0469S00 t1 ");

		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0469s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		List<?> params = (List<?>) mapaWhere.get("params");

		return this.jdbcTemplate.queryForLong(query.toString(),
				params.toArray());
	}

	/**
	 * Reorder the data list of Ab0469s00 selected for rup_table.
	 * 
	 * ab0469s00 Ab0469s00 jqGridRequestDto JQGridRequestDto startsWith Boolean
	 * List<TableRowDto<Ab0469s00>>
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosEnvioPostal>> reorderSelection(
			DatosEnvioPostal ab0469s00, JQGridRequestDto jqGridRequestDto,
			Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosEnvioPostalDaoImpl.QUERY_SELECT);
		// FILTRADO
		// Where clause & Params
		Map<String, ?> mapaWhere = this.getWhereLikeMap(ab0469s00, startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhere.get("query"));
		query.append(where);

		// Parámetros de filtrado
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhere.get("params");

		// SQL para la reordenación
		StringBuilder sbReorderSelectionSQL = JQGridManager.getReorderQuery(
				query, jqGridRequestDto, DatosEnvioPostal.class,
				filterParamList, "ID_DATOS_ENVIO_POSTAL_069");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosEnvioPostal>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/**
	 * Search method for rup_table.
	 * 
	 * filterParams Ab0469s00 searchParams Ab0469s00 jqGridRequestDto
	 * JQGridRequestDto startsWith Boolean List<TableRowDto<Ab0469s00>>
	 *
	 * @param filterParams
	 *            the filter params
	 * @param searchParams
	 *            the search params
	 * @param jqGridRequestDto
	 *            the jq grid request dto
	 * @param startsWith
	 *            the starts with
	 * @return the list
	 */
	@Override()
	public List<TableRowDto<DatosEnvioPostal>> search(
			DatosEnvioPostal filterParams, DatosEnvioPostal searchParams,
			JQGridRequestDto jqGridRequestDto, Boolean startsWith) {
		StringBuilder query = new StringBuilder(
				DatosEnvioPostalDaoImpl.QUERY_SELECT);
		// TABLAS_ALIAS
		List<String> from_alias = new ArrayList<String>();
		from_alias.add(" t1 ");

		// FILTRADO
		Map<String, ?> mapaWhereFilter = this.getWhereLikeMap(filterParams,
				startsWith);
		StringBuilder where = new StringBuilder(" WHERE 1=1 ");
		where.append(mapaWhereFilter.get("query"));
		query.append(where);
		// Filter params
		@SuppressWarnings(value = "unchecked")
		List<Object> filterParamList = (List<Object>) mapaWhereFilter
				.get("params");

		// BUSQUEDA
		Map<String, Object> mapaWhereSearch = this.getWhereLikeMap(searchParams,
				startsWith);
		String searchSQL = ((StringBuilder) mapaWhereSearch.get("query"))
				.toString();
		// Search params
		@SuppressWarnings(value = "unchecked")
		List<Object> searchParamList = (List<Object>) mapaWhereSearch
				.get("params");

		// SQL
		StringBuilder sbReorderSelectionSQL = JQGridManager.getSearchQuery(
				query, jqGridRequestDto, DatosEnvioPostal.class,
				filterParamList, searchSQL, searchParamList, from_alias,
				"ID_DATOS_ENVIO_POSTAL_069");

		return this.jdbcTemplate
				.query(sbReorderSelectionSQL.toString(),
						new RowNumResultSetExtractor<DatosEnvioPostal>(
								this.rwMapPK, jqGridRequestDto),
						filterParamList.toArray());
	}

	/*
	 * MÉTODOS PRIVADOS
	 */

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0469s00 entity.
	 * 
	 * ab0469s00 Ab0469s00 Bean with the criteria values to filter by. Map
	 * created with two keys key query stores the sql query syntax key params
	 * stores the parameter values to be used in the condition sentence.
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @return the where map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, ?> getWhereMap(DatosEnvioPostal ab0469s00) {

		StringBuilder where = new StringBuilder(
				DatosEnvioPostalDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0469s00 != null && ab0469s00.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_069 = ?");
			params.add(ab0469s00.getIdDatosEnvioPostal069());
		}
		if (ab0469s00 != null && ab0469s00.getIdEnvio069() != null) {
			where.append(" AND t1.ID_ENVIO_069 = ?");
			params.add(ab0469s00.getIdEnvio069());
		}
		if (ab0469s00 != null && ab0469s00.getCodEnvio069() != null) {
			where.append(" AND t1.COD_ENVIO_069 = ?");
			params.add(ab0469s00.getCodEnvio069());
		}
		if (ab0469s00 != null && ab0469s00.getIdRemesa069() != null) {
			where.append(" AND t1.ID_REMESA_069 = ?");
			params.add(ab0469s00.getIdRemesa069());
		}
		if (ab0469s00 != null && ab0469s00.getCodRemesa069() != null) {
			where.append(" AND t1.COD_REMESA_069 = ?");
			params.add(ab0469s00.getCodRemesa069());
		}
		if (ab0469s00 != null && ab0469s00.getIdColeccion069() != null) {
			where.append(" AND t1.ID_COLECCION_069 = ?");
			params.add(ab0469s00.getIdColeccion069());
		}
		if (ab0469s00 != null && ab0469s00.getCodColeccion069() != null) {
			where.append(" AND t1.COD_COLECCION_069 = ?");
			params.add(ab0469s00.getCodColeccion069());
		}
		if (ab0469s00 != null && ab0469s00.getCodSituacionEnvio069() != null) {
			where.append(" AND t1.COD_SITUACION_ENVIO_069 = ?");
			params.add(ab0469s00.getCodSituacionEnvio069());
		}
		if (ab0469s00 != null
				&& ab0469s00.getDescSituacionEnvioEs069() != null) {
			where.append(" AND t1.DESC_SITUACION_ENVIO_ES_069 = ?");
			params.add(ab0469s00.getDescSituacionEnvioEs069());
		}
		if (ab0469s00 != null
				&& ab0469s00.getDescSituacionEnvioEu069() != null) {
			where.append(" AND t1.DESC_SITUACION_ENVIO_EU_069 = ?");
			params.add(ab0469s00.getDescSituacionEnvioEu069());
		}
		if (ab0469s00 != null && ab0469s00.getEstadoEnvio069() != null) {
			where.append(" AND t1.ESTADO_ENVIO_069 = ?");
			params.add(ab0469s00.getEstadoEnvio069());
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * Returns a map with the needed value to create the conditions to filter by
	 * the Ab0469s00 entity.
	 * 
	 * ab0469s00 Ab0469s00 Bean with the criteria values to filter by.
	 * startsWith Boolean Map created with two keys key query stores the sql
	 * query syntax key params stores the parameter values to be used in the
	 * condition sentence.
	 *
	 * @param ab0469s00
	 *            the ab 0469 s 00
	 * @param startsWith
	 *            the starts with
	 * @return the where like map
	 */
	// CHECKSTYLE:OFF CyclomaticComplexity - Generación de código de UDA
	private Map<String, Object> getWhereLikeMap(DatosEnvioPostal ab0469s00,
			Boolean startsWith) {

		StringBuilder where = new StringBuilder(
				DatosEnvioPostalDaoImpl.STRING_BUILDER_INIT);
		List<Object> params = new ArrayList<Object>();

		if (ab0469s00 != null && ab0469s00.getIdDatosEnvioPostal069() != null) {
			where.append(" AND t1.ID_DATOS_ENVIO_POSTAL_069 = ?");
			params.add(ab0469s00.getIdDatosEnvioPostal069());
		}
		if (ab0469s00 != null && ab0469s00.getIdEnvio069() != null) {
			where.append(" AND t1.ID_ENVIO_069 = ?");
			params.add(ab0469s00.getIdEnvio069());
		}
		if (ab0469s00 != null && ab0469s00.getCodEnvio069() != null) {
			where.append(" AND UPPER(t1.COD_ENVIO_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getCodEnvio069().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0469s00.getCodEnvio069().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_ENVIO_069 IS NOT NULL");
		}
		if (ab0469s00 != null && ab0469s00.getIdRemesa069() != null) {
			where.append(" AND t1.ID_REMESA_069 = ?");
			params.add(ab0469s00.getIdRemesa069());
		}
		if (ab0469s00 != null && ab0469s00.getCodRemesa069() != null) {
			where.append(" AND UPPER(t1.COD_REMESA_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getCodRemesa069().toUpperCase() + "%");
			} else {
				params.add(
						"%" + ab0469s00.getCodRemesa069().toUpperCase() + "%");
			}
			where.append(" AND t1.COD_REMESA_069 IS NOT NULL");
		}
		if (ab0469s00 != null && ab0469s00.getIdColeccion069() != null) {
			where.append(" AND t1.ID_COLECCION_069 = ?");
			params.add(ab0469s00.getIdColeccion069());
		}
		if (ab0469s00 != null && ab0469s00.getCodColeccion069() != null) {
			where.append(
					" AND UPPER(t1.COD_COLECCION_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getCodColeccion069().toUpperCase() + "%");
			} else {
				params.add("%" + ab0469s00.getCodColeccion069().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.COD_COLECCION_069 IS NOT NULL");
		}
		if (ab0469s00 != null && ab0469s00.getCodSituacionEnvio069() != null) {
			where.append(
					" AND UPPER(t1.COD_SITUACION_ENVIO_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getCodSituacionEnvio069().toUpperCase()
						+ "%");
			} else {
				params.add(
						"%" + ab0469s00.getCodSituacionEnvio069().toUpperCase()
								+ "%");
			}
			where.append(" AND t1.COD_SITUACION_ENVIO_069 IS NOT NULL");
		}
		if (ab0469s00 != null
				&& ab0469s00.getDescSituacionEnvioEs069() != null) {
			where.append(
					" AND UPPER(t1.DESC_SITUACION_ENVIO_ES_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getDescSituacionEnvioEs069().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ab0469s00.getDescSituacionEnvioEs069().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_SITUACION_ENVIO_ES_069 IS NOT NULL");
		}
		if (ab0469s00 != null
				&& ab0469s00.getDescSituacionEnvioEu069() != null) {
			where.append(
					" AND UPPER(t1.DESC_SITUACION_ENVIO_EU_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getDescSituacionEnvioEu069().toUpperCase()
						+ "%");
			} else {
				params.add("%"
						+ ab0469s00.getDescSituacionEnvioEu069().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.DESC_SITUACION_ENVIO_EU_069 IS NOT NULL");
		}
		if (ab0469s00 != null && ab0469s00.getEstadoEnvio069() != null) {
			where.append(" AND UPPER(t1.ESTADO_ENVIO_069) like ? ESCAPE  '\\'");
			if (startsWith) {
				params.add(ab0469s00.getEstadoEnvio069().toUpperCase() + "%");
			} else {
				params.add("%" + ab0469s00.getEstadoEnvio069().toUpperCase()
						+ "%");
			}
			where.append(" AND t1.ESTADO_ENVIO_069 IS NOT NULL");
		}

		Map<String, Object> mapWhere = new HashMap<String, Object>();
		mapWhere.put("query", where);
		mapWhere.put("params", params);

		return mapWhere;
	}
	// CHECKSTYLE:ON CyclomaticComplexity - Generación de código de UDA

	/**
	 * StringBuilder initilization value
	 */
	public static final int STRING_BUILDER_INIT = 4096;
}
